/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.IVWTaskServiceManager;
import filenet.vw.apps.taskman.VWTaskServiceManager;
import filenet.vw.apps.taskman.VWTaskServiceProperties;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;

public class VWTaskServiceController {
    private static Logger m_logger = Logger.getLogger("filenet.vw.apps.taskman");
    private static String m_className = VWTaskServiceController.class.getName();
    private static VWTaskServiceController m_instance = new VWTaskServiceController();
    private static final String LOCK_PREFIX = "taskmanservicelock";
    private File m_lockFileDirectory = null;
    public static final String ACTION_START = "start";
    public static final String ACTION_STOP = "stop";

    public static VWTaskServiceController getInstance() {
        return m_instance;
    }

    public File getLock(String action) throws Exception {
        String method = "getLock";
        m_logger.entering(m_className, method);
        File lock = File.createTempFile(LOCK_PREFIX, "." + action, this.m_lockFileDirectory);
        lock.deleteOnExit();
        m_logger.fine(m_className, method, "Created lock file: " + lock.getPath() + " : " + lock.lastModified());
        boolean bAccessGranted = false;
        while (!bAccessGranted) {
            File oldestLock = this.getOldestLock();
            while (!lock.equals(oldestLock)) {
                if (m_logger.isFinest()) {
                    m_logger.finest(m_className, method, "Oldest lock file: " + oldestLock.getPath());
                }
                long curTime = new Date().getTime();
                long lastActionTimeStamp = -1L;
                try {
                    lastActionTimeStamp = Long.parseLong(VWTaskServiceProperties.getInstance().getProperty("TaskServiceManager.LastActionTimeStamp"));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if ((curTime - lastActionTimeStamp > 60000L || lastActionTimeStamp == -1L) && curTime - oldestLock.lastModified() > 60000L) {
                    try {
                        IVWTaskServiceManager sm = VWTaskServiceManager.lookupServiceManager();
                        sm.ping();
                        File smLock = sm.getLock();
                        if (smLock == null || !smLock.equals(oldestLock)) {
                            throw new Exception("Oldest lock file not in use");
                        }
                    }
                    catch (Exception ex) {
                        try {
                            m_logger.log(Level.FINE, m_className, method, "Oldest lock file not in use.", ex);
                            oldestLock.delete();
                            m_logger.fine(m_className, method, "Deleted timed-out lock file: " + oldestLock.getPath());
                        }
                        catch (Exception e) {
                            m_logger.log(Level.FINE, m_className, method, "Unable to delete timed-out lock file: " + oldestLock.getPath(), e);
                        }
                    }
                }
                Thread.sleep(1000L);
                oldestLock = this.getOldestLock();
            }
            if (action.equals(VWTaskServiceProperties.getInstance().getProperty("TaskServiceManager.LastAction"))) {
                File inSequenceLock = this.getOldestInSequenceLock();
                if (inSequenceLock != null) {
                    m_logger.fine(m_className, method, "Oldest lock is out of sequence - allowing next in sequence lock access.");
                    m_logger.fine(m_className, method, "Oldest lock file: " + oldestLock.getPath());
                    m_logger.fine(m_className, method, "Next in sequence lock: " + inSequenceLock.getPath());
                    VWTaskServiceProperties.getInstance().setProperty("TaskServiceManager.OutOfSequenceLock", inSequenceLock.getPath());
                    continue;
                }
                bAccessGranted = true;
                continue;
            }
            bAccessGranted = true;
        }
        m_logger.fine(m_className, method, "Lock granted for file: " + lock.getPath());
        VWTaskServiceProperties.getInstance().setProperty("TaskServiceManager.LastAction", action);
        VWTaskServiceProperties.getInstance().setProperty("TaskServiceManager.LastActionTimeStamp", "" + new Date().getTime());
        m_logger.exiting(m_className, method);
        return lock;
    }

    public void releaseLock(File lockFile) {
        String method = "releaseLock:" + lockFile.getPath();
        m_logger.entering(m_className, method);
        try {
            VWTaskServiceProperties.getInstance().setProperty("TaskServiceManager.OutOfSequenceLock", "");
            lockFile.delete();
        }
        catch (Exception ex) {
            m_logger.log(Level.SEVERE, m_className, method, ex.getMessage(), ex);
        }
        m_logger.exiting(m_className, method);
    }

    private VWTaskServiceController() {
        String taskmanprops = System.getProperty("TaskManager.Properties");
        this.m_lockFileDirectory = new File(VWTaskUtil.removeTrailingSlash(new File(taskmanprops).getParent()));
    }

    private File getOldestLock() {
        File oosLock;
        String method = "getOldestLock";
        m_logger.entering(m_className, method);
        String temp = VWTaskServiceProperties.getInstance().getProperty("TaskServiceManager.OutOfSequenceLock");
        if (temp != null && !temp.equals("") && (oosLock = new File(temp)).exists()) {
            return oosLock;
        }
        File oldest = this.getOldestFile(this.m_lockFileDirectory.listFiles(new LockFilter(null)));
        if (oldest == null) {
            throw new IllegalStateException("Lock file not found.");
        }
        m_logger.exiting(m_className, method);
        return oldest;
    }

    private File getOldestInSequenceLock() {
        String method = "getOldestInSequenceLock";
        m_logger.entering(m_className, method);
        File oldest = null;
        int retryCount = 0;
        while (oldest == null && retryCount < 10) {
            oldest = this.getOldestFile(this.m_lockFileDirectory.listFiles(new LockFilter(VWTaskServiceProperties.getInstance().getProperty("TaskServiceManager.LastAction"))));
            if (oldest != null) continue;
            ++retryCount;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {}
        }
        m_logger.exiting(m_className, method);
        return oldest;
    }

    private File getOldestFile(File[] files) {
        File oldest = null;
        for (int i = 0; i < files.length; ++i) {
            long lastModified = files[i].lastModified();
            if (oldest != null && lastModified >= oldest.lastModified()) continue;
            oldest = files[i];
        }
        return oldest;
    }

    private class LockFilter
    implements FileFilter {
        String lastAction = null;

        public LockFilter(String lastAction) {
            this.lastAction = lastAction;
        }

        public boolean accept(File file) {
            if (file.getName().startsWith(VWTaskServiceController.LOCK_PREFIX)) {
                if (this.lastAction == null) {
                    return true;
                }
                return !file.getName().endsWith(this.lastAction);
            }
            return false;
        }
    }
}

